<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model 
{

    protected $table = 'categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en');
    protected $visible = array('name_ar', 'name_en');

    public function works()
    {
        return $this->hasMany('App\Models\Work', 'category_id');
    }

}